/*
 * Decompiled with CFR 0.152.
 */
package org.bluez.v4;

import com.intel.bluetooth.DebugLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bluez.BlueZAPI;
import org.bluez.Error;
import org.bluez.dbus.DBusProperties;
import org.bluez.v4.Adapter;
import org.bluez.v4.Agent;
import org.bluez.v4.Device;
import org.bluez.v4.Manager;
import org.bluez.v4.Service;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueZAPIV4
implements BlueZAPI {
    private DBusConnection dbusConn;
    private Manager dbusManager;
    private Adapter adapter;
    private Path adapterPath;

    public BlueZAPIV4(DBusConnection dbusConn, Manager dbusManager) {
        this.dbusConn = dbusConn;
        this.dbusManager = dbusManager;
    }

    @Override
    public Path findAdapter(String pattern) throws Error.InvalidArguments {
        try {
            return this.dbusManager.FindAdapter(pattern);
        }
        catch (Error.NoSuchAdapter e) {
            return null;
        }
    }

    @Override
    public Path defaultAdapter() throws Error.InvalidArguments {
        try {
            return this.dbusManager.DefaultAdapter();
        }
        catch (Error.NoSuchAdapter e) {
            return null;
        }
    }

    @Override
    public Path getAdapter(int number) {
        Path[] adapters = this.dbusManager.ListAdapters();
        if (adapters == null) {
            throw null;
        }
        if (number < 0 || number >= adapters.length) {
            throw null;
        }
        return adapters[number];
    }

    private String hciID(String adapterPath) {
        String bluezPath = "/org/bluez/";
        String path = adapterPath.startsWith("/org/bluez/") ? adapterPath.substring("/org/bluez/".length()) : adapterPath;
        int lastpart = path.lastIndexOf(47);
        if (lastpart != -1 && lastpart != path.length() - 1) {
            return path.substring(lastpart + 1);
        }
        return path;
    }

    @Override
    public List<String> listAdapters() {
        Vector<String> v = new Vector<String>();
        Path[] adapters = this.dbusManager.ListAdapters();
        if (adapters != null) {
            for (int i = 0; i < adapters.length; ++i) {
                v.add(this.hciID(adapters[i].getPath()));
            }
        }
        return v;
    }

    @Override
    public void selectAdapter(Path adapterPath) throws DBusException {
        DebugLog.debug((String)"selectAdapter", (String)adapterPath.getPath());
        this.adapter = (Adapter)this.dbusConn.getRemoteObject("org.bluez", adapterPath.getPath(), Adapter.class);
        this.adapterPath = adapterPath;
    }

    @Override
    public String getAdapterAddress() {
        return DBusProperties.getStringValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Address);
    }

    @Override
    public String getAdapterID() {
        return this.hciID(this.adapterPath.getPath());
    }

    @Override
    public int getAdapterDeviceClass() {
        Integer deviceClass = DBusProperties.getIntValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Class);
        if (deviceClass == null) {
            return 256;
        }
        return deviceClass;
    }

    @Override
    public String getAdapterName() {
        return DBusProperties.getStringValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Name);
    }

    @Override
    public boolean isAdapterDiscoverable() {
        return DBusProperties.getBooleanValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Discoverable);
    }

    @Override
    public int getAdapterDiscoverableTimeout() {
        return DBusProperties.getIntValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.DiscoverableTimeout);
    }

    @Override
    public boolean setAdapterDiscoverable(int mode) throws DBusException {
        switch (mode) {
            case 0: {
                this.adapter.SetProperty(DBusProperties.getPropertyName(Adapter.Properties.Discoverable), new Variant((Object)Boolean.FALSE));
                break;
            }
            case 10390323: {
                this.adapter.SetProperty(DBusProperties.getPropertyName(Adapter.Properties.DiscoverableTimeout), new Variant((Object)new UInt32(0L)));
                this.adapter.SetProperty(DBusProperties.getPropertyName(Adapter.Properties.Discoverable), new Variant((Object)Boolean.TRUE));
                break;
            }
            case 10390272: {
                this.adapter.SetProperty(DBusProperties.getPropertyName(Adapter.Properties.DiscoverableTimeout), new Variant((Object)new UInt32(180L)));
                this.adapter.SetProperty(DBusProperties.getPropertyName(Adapter.Properties.Discoverable), new Variant((Object)Boolean.TRUE));
                break;
            }
            default: {
                if (10390272 <= mode && mode <= 10390335) {
                    return false;
                }
                throw new IllegalArgumentException("Invalid discoverable mode");
            }
        }
        return true;
    }

    @Override
    public String getAdapterManufacturer() {
        return null;
    }

    @Override
    public String getAdapterRevision() {
        return null;
    }

    @Override
    public String getAdapterVersion() {
        return null;
    }

    @Override
    public boolean isAdapterPowerOn() {
        return DBusProperties.getBooleanValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Powered);
    }

    private <T extends DBusSignal> void quietRemoveSigHandler(Class<T> type, DBusSigHandler<T> handler) {
        try {
            this.dbusConn.removeSigHandler(type, handler);
        }
        catch (DBusException dBusException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceInquiry(final BlueZAPI.DeviceInquiryListener listener) throws DBusException, InterruptedException {
        DBusSigHandler<Adapter.DeviceFound> remoteDeviceFound = new DBusSigHandler<Adapter.DeviceFound>(){

            public void handle(Adapter.DeviceFound s) {
                String deviceName = null;
                int deviceClass = -1;
                boolean paired = false;
                Map<String, Variant<?>> properties = s.getDevicePoperties();
                if (properties != null) {
                    deviceName = DBusProperties.getStringValue(properties, (DBusProperties.PropertyEnum)Device.Properties.Name);
                    deviceClass = DBusProperties.getIntValue(properties, (DBusProperties.PropertyEnum)Device.Properties.Class);
                    paired = DBusProperties.getBooleanValue(properties, Device.Properties.Paired, false);
                }
                listener.deviceDiscovered(s.getDeviceAddress(), deviceName, deviceClass, paired);
            }
        };
        try {
            this.dbusConn.addSigHandler(Adapter.DeviceFound.class, (DBusSigHandler)remoteDeviceFound);
            this.adapter.StartDiscovery();
            listener.deviceInquiryStarted();
            while (DBusProperties.getBooleanValue(this.adapter, (DBusProperties.PropertyEnum)Adapter.Properties.Discovering)) {
                Thread.sleep(200L);
            }
            this.adapter.StopDiscovery();
        }
        finally {
            this.quietRemoveSigHandler(Adapter.DeviceFound.class, remoteDeviceFound);
        }
    }

    @Override
    public void deviceInquiryCancel() throws DBusException {
        this.adapter.StopDiscovery();
    }

    private Device getDevice(String deviceAddress) throws DBusException {
        Path devicePath;
        try {
            devicePath = this.adapter.FindDevice(deviceAddress);
        }
        catch (Error.DoesNotExist e) {
            DebugLog.debug((String)"can't get device", (Throwable)((Object)e));
            devicePath = this.adapter.CreateDevice(deviceAddress);
        }
        return (Device)this.dbusConn.getRemoteObject("org.bluez", devicePath.getPath(), Device.class);
    }

    @Override
    public String getRemoteDeviceFriendlyName(String deviceAddress) throws DBusException, IOException {
        return DBusProperties.getStringValue(this.getDevice(deviceAddress), (DBusProperties.PropertyEnum)Device.Properties.Name);
    }

    @Override
    public List<String> retrieveDevices(boolean preKnown) {
        Path[] devices = this.adapter.ListDevices();
        Vector<String> addresses = new Vector<String>();
        if (devices != null) {
            for (Path devicePath : devices) {
                try {
                    Device device = (Device)this.dbusConn.getRemoteObject("org.bluez", devicePath.getPath(), Device.class);
                    Map properties = device.GetProperties();
                    if (properties == null) continue;
                    String address = DBusProperties.getStringValue(properties, (DBusProperties.PropertyEnum)Device.Properties.Address);
                    boolean paired = DBusProperties.getBooleanValue(properties, Device.Properties.Paired, false);
                    boolean trusted = DBusProperties.getBooleanValue(properties, Device.Properties.Trusted, false);
                    if (preKnown && !paired && !trusted) continue;
                    addresses.add(address);
                }
                catch (DBusException e) {
                    DebugLog.debug((String)("can't get device " + devicePath), (Throwable)e);
                }
            }
        }
        return addresses;
    }

    @Override
    public boolean isRemoteDeviceConnected(String deviceAddress) throws DBusException {
        return DBusProperties.getBooleanValue(this.getDevice(deviceAddress), (DBusProperties.PropertyEnum)Device.Properties.Connected);
    }

    @Override
    public Boolean isRemoteDeviceTrusted(String deviceAddress) throws DBusException {
        return DBusProperties.getBooleanValue(this.getDevice(deviceAddress), (DBusProperties.PropertyEnum)Device.Properties.Paired);
    }

    @Override
    public void authenticateRemoteDevice(String deviceAddress) throws DBusException {
        throw new DBusException("TODO: How to implement this using Agent?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateRemoteDevice(String deviceAddress, final String passkey) throws DBusException {
        if (passkey == null) {
            this.authenticateRemoteDevice(deviceAddress);
            return true;
        }
        Agent agent = new Agent(){

            public void Authorize(Path device, String uuid) throws Error.Rejected, Error.Canceled {
            }

            public void ConfirmModeChange(String mode) throws Error.Rejected, Error.Canceled {
            }

            public void DisplayPasskey(Path device, UInt32 passkey2, byte entered) {
            }

            public void RequestConfirmation(Path device, UInt32 passkey2) throws Error.Rejected, Error.Canceled {
            }

            public UInt32 RequestPasskey(Path device) throws Error.Rejected, Error.Canceled {
                return null;
            }

            public String RequestPinCode(Path device) throws Error.Rejected, Error.Canceled {
                return passkey;
            }

            public void Cancel() {
            }

            public void Release() {
            }

            public boolean isRemote() {
                return false;
            }
        };
        String agentPath = "/org/bluecove/authenticate/" + this.getAdapterID() + "/" + deviceAddress.replace(':', '_');
        DebugLog.debug((String)"export Agent", (String)agentPath);
        this.dbusConn.exportObject(agentPath, (DBusInterface)agent);
        try {
            this.adapter.CreatePairedDevice(deviceAddress, new Path(agentPath), "");
            boolean bl = true;
            return bl;
        }
        finally {
            this.dbusConn.unExportObject(agentPath);
        }
    }

    @Override
    public void removeAuthenticationWithRemoteDevice(String deviceAddress) throws DBusException {
        Path devicePath = this.adapter.FindDevice(deviceAddress);
        this.adapter.RemoveDevice(devicePath);
    }

    @Override
    public Map<Integer, String> getRemoteDeviceServices(String deviceAddress) throws DBusException {
        Path devicePath;
        try {
            devicePath = this.adapter.FindDevice(deviceAddress);
        }
        catch (Error.DoesNotExist e) {
            devicePath = this.adapter.CreateDevice(deviceAddress);
        }
        Device device = (Device)this.dbusConn.getRemoteObject("org.bluez", devicePath.getPath(), Device.class);
        Map<UInt32, String> xmlMap = device.DiscoverServices("");
        HashMap<Integer, String> xmlRecords = new HashMap<Integer, String>();
        for (Map.Entry<UInt32, String> record : xmlMap.entrySet()) {
            xmlRecords.put(record.getKey().intValue(), record.getValue());
        }
        return xmlRecords;
    }

    private Service getSDPService() throws DBusException {
        return (Service)this.dbusConn.getRemoteObject("org.bluez", this.adapterPath.getPath(), Service.class);
    }

    @Override
    public long registerSDPRecord(String sdpXML) throws DBusException {
        DebugLog.debug((String)"AddRecord", (String)sdpXML);
        UInt32 handle = this.getSDPService().AddRecord(sdpXML);
        return handle.longValue();
    }

    @Override
    public void updateSDPRecord(long handle, String sdpXML) throws DBusException {
        DebugLog.debug((String)"UpdateRecord", (String)sdpXML);
        this.getSDPService().UpdateRecord(new UInt32(handle), sdpXML);
    }

    @Override
    public void unregisterSDPRecord(long handle) throws DBusException {
        DebugLog.debug((String)"RemoveRecord", (long)handle);
        this.getSDPService().RemoveRecord(new UInt32(handle));
    }
}

