/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.renderers.GaugePainter;
import com.efiAnalytics.apps.ts.dashboard.s;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class HorizontalBarPainter
implements GaugePainter {
    String name = "Horizontal Bar Gauge";
    transient Image offImage = null;
    static final transient Color transparent = new Color(255, 255, 255, 0);

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        if (gauge.isCounterClockwise()) {
            Image image = this.getOffImage(gauge);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(transparent);
            ((Graphics2D)graphics2).setComposite(AlphaComposite.getInstance(2));
            graphics2.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
            this.paintBar(graphics2, gauge);
            this.paintBorder(graphics2, gauge);
            graphics.drawImage(image, gauge.getWidth(), 0, -gauge.getWidth(), gauge.getHeight(), null);
        } else {
            this.paintBar(graphics, gauge);
            this.paintBorder(graphics, gauge);
        }
    }

    protected void paintBar(Graphics graphics, Gauge gauge) {
        int n2;
        double d2 = (gauge.getSmoothedValue() - gauge.min()) / (gauge.max() - gauge.min());
        double d3 = (gauge.highWarning() - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = (gauge.highCritical() - gauge.min()) / (gauge.max() - gauge.min());
        int n3 = (int)((double)gauge.getWidth() * d2);
        graphics.setColor(gauge.getBackColor());
        graphics.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        graphics.setColor(gauge.getFontColor());
        graphics.fillRect(0, 0, n3, gauge.getHeight());
        if (d2 > d3) {
            graphics.setColor(gauge.getWarnColor());
            n2 = (int)((double)gauge.getWidth() * d3);
            graphics.fillRect(n2, 0, n3 - n2, gauge.getHeight());
        }
        if (d2 > d4) {
            graphics.setColor(gauge.getCriticalColor());
            n2 = (int)((double)gauge.getWidth() * d4);
            graphics.fillRect(n2, 0, n3 - n2, gauge.getHeight());
        }
        double d5 = Math.abs((gauge.getHistoricalPeakValue() - gauge.min()) / (gauge.max() - gauge.min()));
        if (gauge.isShowHistory() && d5 - d2 > 0.008) {
            if (d5 > d4) {
                graphics.setColor(gauge.getCriticalColor());
            } else if (d5 > d3) {
                graphics.setColor(gauge.getWarnColor());
            } else {
                graphics.setColor(gauge.getFontColor());
            }
            n3 = (int)((double)gauge.getWidth() * d5);
            graphics.drawLine(n3, 0, n3, gauge.getHeight());
        }
    }

    protected void paintBorder(Graphics graphics, Gauge gauge) {
        graphics.setColor(gauge.getTrimColor());
        for (int i2 = 0; i2 < gauge.getBorderWidth(); ++i2) {
            graphics.draw3DRect(i2, i2, gauge.getWidth() - 1 - 2 * i2, gauge.getHeight() - 1 - 2 * i2, gauge.getBorderWidth() / 2 >= i2);
        }
    }

    @Override
    public void invalidate() {
        this.offImage = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    protected Image getOffImage(Gauge gauge) {
        if (this.offImage == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.offImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 3);
        }
        return this.offImage;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        return false;
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        if (gauge.isCounterClockwise()) {
            Image image = this.getOffImage(gauge);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(transparent);
            ((Graphics2D)graphics2).setComposite(AlphaComposite.getInstance(2));
            graphics2.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
            this.paintBar(graphics2, gauge);
            this.paintBorder(graphics2, gauge);
            graphics.drawImage(image, gauge.getWidth(), 0, -gauge.getWidth(), gauge.getHeight(), null);
        } else {
            this.paintBar(graphics, gauge);
            this.paintBorder(graphics, gauge);
        }
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
    }

    @Override
    public Area areaPainted(s s2) {
        Gauge gauge = (Gauge)s2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, gauge.getWidth(), gauge.getHeight());
        Area area = new Area(double_);
        return area;
    }
}

