/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.remotefileaccess.http;

import aD.r;
import bQ.C;
import bQ.m;
import com.efiAnalytics.fileIo.json.JsonObjectPersistor;
import com.efiAnalytics.remotefileaccess.DirectoryFiles;
import com.efiAnalytics.remotefileaccess.DirectoryIdentifier;
import com.efiAnalytics.remotefileaccess.DirectoryInformation;
import com.efiAnalytics.remotefileaccess.FileDownloadProgressListener;
import com.efiAnalytics.remotefileaccess.RefreshNeededListener;
import com.efiAnalytics.remotefileaccess.RemoteAccessException;
import com.efiAnalytics.remotefileaccess.RemoteFileAccess;
import com.efiAnalytics.remotefileaccess.RemoteFileDescriptor;
import com.efiAnalytics.remotefileaccess.http.FileAccessPreferences;
import com.efiAnalytics.remotefileaccess.http.HttpDirectoryInfo;
import com.efiAnalytics.remotefileaccess.http.HttpFileAccess$MyDownloadProgressListener;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpFileAccess
implements RemoteFileAccess {
    String hostName;
    List fileDownloadListeners = new ArrayList();
    List refreshListeners = new ArrayList();
    HttpFileAccess$MyDownloadProgressListener dlListener = new HttpFileAccess$MyDownloadProgressListener(this);
    File downloadDirectory = null;
    int port;
    private FileAccessPreferences fileAccessPreferences = null;

    public HttpFileAccess(String string, int n2, File file) {
        this.hostName = string;
        this.downloadDirectory = file;
        this.port = n2;
    }

    private String getCoreUrl(String string) {
        String string2 = this.port == 80 ? "http://" + this.hostName + "/LogFileActions?" : "http://" + this.hostName + ":" + this.port + "/LogFileActions?";
        if (string != null && !string.isEmpty()) {
            string2 = string2 + "projectName=" + string + "&";
        }
        return string2;
    }

    @Override
    public DirectoryFiles getFilesIn(DirectoryIdentifier directoryIdentifier) {
        String string;
        String string2 = this.getCoreUrl(directoryIdentifier == null ? null : directoryIdentifier.getDirectoryId());
        string2 = string2 + "action=listLogs";
        try {
            string = r.a(string2);
        }
        catch (IOException iOException) {
            C.a("Failed to read from url: " + string2);
            throw new RemoteAccessException("Unable to read file list from " + this.hostName + ", error: " + iOException.getLocalizedMessage());
        }
        if (string.toLowerCase().startsWith("error")) {
            throw new RemoteAccessException(string);
        }
        try {
            List list = JsonObjectPersistor.readList(RemoteFileDescriptor[].class, string);
            DirectoryInformation directoryInformation = this.getDirectoryInformation(directoryIdentifier);
            DirectoryFiles directoryFiles = new DirectoryFiles();
            directoryFiles.setDirectoryInformation(directoryInformation);
            directoryFiles.setFiles(list);
            return directoryFiles;
        }
        catch (Exception exception) {
            C.a("Could not parse this json: " + string);
            throw new RemoteAccessException("Error parsing response from " + this.hostName + ", error: " + exception.getLocalizedMessage());
        }
    }

    @Override
    public File readRemoteFile(File file, RemoteFileDescriptor remoteFileDescriptor) {
        String string = this.getCoreUrl(remoteFileDescriptor.getDirectory().getDirectoryId());
        if (remoteFileDescriptor.getName() == null || remoteFileDescriptor.getName().isEmpty()) {
            throw new RemoteAccessException("fileName is required!");
        }
        string = string + "action=downloadLog&logFileName=" + remoteFileDescriptor.getName();
        if (this.fileAccessPreferences != null) {
            file = new File(this.fileAccessPreferences.getDownloadDirectory());
        } else if (file == null || !file.exists()) {
            file = this.downloadDirectory;
        }
        File file2 = new File(file, remoteFileDescriptor.getName());
        int n2 = 1;
        if (this.fileAccessPreferences != null && this.fileAccessPreferences.getFileExistsPreference() != 1) {
            if (this.fileAccessPreferences.getFileExistsPreference() == 0) {
                if (remoteFileDescriptor.getSize() == file2.length()) {
                    this.dlListener.setDownloadFile(file2);
                    this.dlListener.setFileDescriptor(remoteFileDescriptor);
                    this.dlListener.started(file2.length());
                    this.dlListener.updateProgress(file2.length(), 1.0);
                    this.dlListener.completed();
                    return file2;
                }
                C.c("Preference to return local, but local file and remote file are different sizes, going to overwrite.");
            } else {
                while (file2.exists()) {
                    file2 = new File(file, remoteFileDescriptor.getName() + "(" + n2++ + ")");
                }
            }
        }
        try {
            this.dlListener.setFileDescriptor(remoteFileDescriptor);
            this.dlListener.setDownloadFile(file2);
            m.a(string, file2.getAbsolutePath(), this.dlListener);
            file2.setLastModified(remoteFileDescriptor.getLastModified());
        }
        catch (IOException iOException) {
            Logger.getLogger(HttpFileAccess.class.getName()).log(Level.WARNING, "File Download Failed.", iOException);
            throw new RemoteAccessException("Failed to download " + remoteFileDescriptor.getName() + ", Error: " + iOException.getLocalizedMessage());
        }
        return file2;
    }

    @Override
    public boolean deleteFile(RemoteFileDescriptor remoteFileDescriptor) {
        String string = this.getCoreUrl(URLEncoder.encode(remoteFileDescriptor.getDirectory().getDirectoryId()));
        if (remoteFileDescriptor.getName() == null || remoteFileDescriptor.getName().isEmpty()) {
            throw new RemoteAccessException("fileName is required!");
        }
        string = string + "action=deleteLog&logFileName=" + URLEncoder.encode(remoteFileDescriptor.getName());
        try {
            String string2 = m.a(string);
            if (string2.equals("SUCCESSFUL")) {
                this.notifyRefreshNeeded();
                return true;
            }
            throw new RemoteAccessException("Delete file " + remoteFileDescriptor.getName() + " failed, Error: " + string2);
        }
        catch (IOException iOException) {
            Logger.getLogger(HttpFileAccess.class.getName()).log(Level.WARNING, "Unable to delete file", iOException);
            throw new RemoteAccessException("Unable to delete file " + remoteFileDescriptor.getName() + ", Error: " + iOException.getLocalizedMessage());
        }
    }

    @Override
    public File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public DirectoryInformation getDirectoryInformation(DirectoryIdentifier directoryIdentifier) {
        String string;
        String string2 = this.getCoreUrl(directoryIdentifier == null ? null : directoryIdentifier.getDirectoryId());
        string2 = string2 + "action=getDirectoryInfo";
        try {
            string = m.a(string2);
        }
        catch (IOException iOException) {
            C.a("Failed to read from url: " + string2);
            throw new RemoteAccessException("Unable to read file list from " + this.hostName + ", error: " + iOException.getLocalizedMessage());
        }
        try {
            return (DirectoryInformation)JsonObjectPersistor.readObject(HttpDirectoryInfo.class, string);
        }
        catch (IOException iOException) {
            C.a("Could not parse this json: " + string);
            throw new RemoteAccessException("Error parsing response from " + this.hostName + ", error: " + iOException.getLocalizedMessage());
        }
    }

    private void notifyRefreshNeeded() {
        for (RefreshNeededListener refreshNeededListener : this.refreshListeners) {
            refreshNeededListener.refreshView();
        }
    }

    @Override
    public void addRefreshNeededListener(RefreshNeededListener refreshNeededListener) {
        this.refreshListeners.add(refreshNeededListener);
    }

    @Override
    public void removeRefreshNeededListener(RefreshNeededListener refreshNeededListener) {
        this.refreshListeners.remove(refreshNeededListener);
    }

    @Override
    public void addFileDownloadProgressListener(FileDownloadProgressListener fileDownloadProgressListener) {
        this.fileDownloadListeners.add(fileDownloadProgressListener);
    }

    @Override
    public void removeFileDownloadProgressListener(FileDownloadProgressListener fileDownloadProgressListener) {
        this.fileDownloadListeners.remove(fileDownloadProgressListener);
    }

    @Override
    public void cancelReadFile() {
    }

    public void setFileAccessPreferences(FileAccessPreferences fileAccessPreferences) {
        this.fileAccessPreferences = fileAccessPreferences;
    }
}

