/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import javax.swing.table.TableCellRenderer;

public class TinyCheckBoxIcon
extends MetalCheckBoxIcon {
    private static final HashMap cache = new HashMap();
    private static int checkSize = 13;
    private static final int[][] a = new int[][]{{255, 255, 255, 242, 228, 209, 187, 165, 142, 120, 104}, {255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 86}, {255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72}, {242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56}, {228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42}, {209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28}, {187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17}, {165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9}, {142, 120, 104, 86, 72, 56, 42, 28, 17, 9, 0}, {120, 104, 86, 72, 56, 42, 28, 17, 9, 0, 0}, {104, 86, 72, 56, 42, 28, 17, 9, 0, 0, 0}};

    public static void clearCache() {
        cache.clear();
    }

    protected int getControlSize() {
        return this.getIconWidth();
    }

    private void paintFlatCheck(JCheckBox jCheckBox, Graphics graphics, int n, int n2) {
        if (jCheckBox.isSelected()) {
            if (!jCheckBox.isEnabled()) {
                graphics.setColor(Theme.buttonCheckDisabledColor.getColor());
            } else {
                graphics.setColor(Theme.buttonCheckColor.getColor());
            }
            this.drawXpCheckMark(graphics, n, n2);
        }
        graphics.setColor(Theme.buttonBorderColor.getColor());
        graphics.drawRect(n, n2, checkSize - 1, checkSize - 1);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        JCheckBox jCheckBox = (JCheckBox)component;
        Container container = jCheckBox.getParent();
        if (jCheckBox.isBorderPaintedFlat() || jCheckBox instanceof TableCellRenderer || container instanceof JTable) {
            this.paintFlatCheck(jCheckBox, graphics, n, n2);
            return;
        }
        ColorUIResource colorUIResource = null;
        colorUIResource = !jCheckBox.isEnabled() ? Theme.buttonDisabledColor.getColor() : (jCheckBox.getModel().isPressed() ? (jCheckBox.getModel().isRollover() ? Theme.buttonPressedColor.getColor() : Theme.buttonNormalColor.getColor()) : (jCheckBox.getModel().isRollover() ? Theme.buttonRolloverBgColor.getColor() : Theme.buttonNormalColor.getColor()));
        graphics.setColor(colorUIResource);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpCheckNoCache(graphics, jCheckBox, colorUIResource, n, n2, this.getIconWidth(), this.getIconHeight());
        } else {
            this.drawXpCheck(graphics, jCheckBox, colorUIResource, n, n2, this.getIconWidth(), this.getIconHeight());
        }
        if (!jCheckBox.isSelected()) {
            return;
        }
        if (!jCheckBox.isEnabled()) {
            graphics.setColor(Theme.buttonCheckDisabledColor.getColor());
        } else {
            graphics.setColor(Theme.buttonCheckColor.getColor());
        }
        this.drawXpCheckMark(graphics, n, n2);
    }

    private void drawXpCheck(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2;
        boolean bl3 = abstractButton.getModel().isPressed();
        boolean bl4 = abstractButton.getModel().isArmed();
        boolean bl5 = abstractButton.isEnabled();
        CheckKey checkKey = new CheckKey(color, bl3, bl5, (bl2 = abstractButton.getModel().isRollover()) || bl4, bl = Theme.buttonFocusBorder.getValue() && !bl2 && abstractButton.isFocusOwner());
        Object v = cache.get(checkKey);
        if (v != null) {
            graphics.drawImage((Image)v, n, n2, abstractButton);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        int n5 = Theme.buttonSpreadLight.getValue();
        int n6 = Theme.buttonSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            n5 = Theme.buttonSpreadLightDisabled.getValue();
            n6 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int n7 = n5 * 5;
        int n8 = n6 * 4;
        if (bl3 && (bl2 || bl4)) {
            n8 *= 2;
        }
        color = ColorRoutines.lighten(color, n7);
        graphics2.setColor(ColorRoutines.darken(color, n8));
        graphics2.fillRect(1, 1, n3 - 2, n4 - 2);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - a[j][i]);
                graphics2.setColor(color2);
                graphics2.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        if (!abstractButton.isEnabled()) {
            graphics2.setColor(Theme.buttonBorderDisabledColor.getColor());
            graphics2.drawRect(0, 0, n3 - 1, n4 - 1);
        } else {
            graphics2.setColor(Theme.buttonBorderColor.getColor());
            graphics2.drawRect(0, 0, n3 - 1, n4 - 1);
            if (bl2 && Theme.buttonRolloverBorder.getValue() && !bl3) {
                DrawRoutines.drawRolloverCheckBorder(graphics2, Theme.buttonRolloverColor.getColor(), 0, 0, n3, n4);
            } else if (bl && !bl3) {
                DrawRoutines.drawRolloverCheckBorder(graphics2, Theme.buttonDefaultColor.getColor(), 0, 0, n3, n4);
            }
        }
        graphics2.dispose();
        graphics.drawImage(bufferedImage, n, n2, abstractButton);
        cache.put(checkKey, bufferedImage);
    }

    private void drawXpCheckNoCache(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, int n3, int n4) {
        Color color2;
        boolean bl = abstractButton.getModel().isPressed();
        boolean bl2 = abstractButton.getModel().isArmed();
        boolean bl3 = abstractButton.isEnabled();
        boolean bl4 = abstractButton.getModel().isRollover();
        boolean bl5 = Theme.buttonFocusBorder.getValue() && !bl4 && abstractButton.isFocusOwner();
        boolean bl6 = !bl && !bl2 && !bl4 && !bl5;
        BufferedImage bufferedImage = null;
        Object object = null;
        if (bl6) {
            object = bl3 ? new EnabledCheckKey(color, Theme.buttonBorderColor.getColor()) : new DisabledCheckKey(color, Theme.buttonBorderDisabledColor.getColor());
            Object v = cache.get(object);
            if (v != null) {
                graphics.drawImage((Image)v, n, n2, abstractButton);
                return;
            }
            bufferedImage = new BufferedImage(n3, n4, 2);
        }
        int n5 = Theme.buttonSpreadLight.getValue();
        int n6 = Theme.buttonSpreadDark.getValue();
        if (!bl3) {
            n5 = Theme.buttonSpreadLightDisabled.getValue();
            n6 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int n7 = n5 * 5;
        int n8 = n6 * 4;
        if (bl && (bl4 || bl2)) {
            n8 *= 2;
        }
        color = ColorRoutines.lighten(color, n7);
        Graphics graphics2 = null;
        int n9 = n;
        int n10 = n2;
        if (bufferedImage != null) {
            graphics2 = ((Image)bufferedImage).getGraphics();
            color2 = abstractButton.getBackground();
            if (!abstractButton.isOpaque()) {
                Container container;
                color2 = container.getBackground();
                for (container = abstractButton.getParent(); container != null && !container.isOpaque(); container = container.getParent()) {
                    color2 = container.getBackground();
                }
            }
            graphics2.setColor(color2);
            graphics2.fillRect(0, 0, n3 - 1, n4 - 1);
            n9 = 0;
            n10 = 0;
        } else {
            graphics2 = graphics;
            graphics2.translate(n, n2);
        }
        graphics2.setColor(ColorRoutines.darken(color, n8));
        graphics2.fillRect(1, 1, n3 - 2, n4 - 2);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - a[j][i]);
                graphics2.setColor(color2);
                graphics2.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        if (bufferedImage == null) {
            graphics2.translate(-n, -n2);
        }
        if (!bl3) {
            graphics2.setColor(Theme.buttonBorderDisabledColor.getColor());
            graphics2.drawRect(n9, n10, n3 - 1, n4 - 1);
        } else {
            graphics2.setColor(Theme.buttonBorderColor.getColor());
            graphics2.drawRect(n9, n10, n3 - 1, n4 - 1);
            if (bl4 && Theme.buttonRolloverBorder.getValue() && !bl) {
                DrawRoutines.drawRolloverCheckBorder(graphics2, Theme.buttonRolloverColor.getColor(), n9, n10, n3, n4);
            } else if (bl5 && !bl) {
                DrawRoutines.drawRolloverCheckBorder(graphics2, Theme.buttonDefaultColor.getColor(), n9, n10, n3, n4);
            }
        }
        if (bufferedImage != null) {
            graphics2.dispose();
            graphics.drawImage(bufferedImage, n, n2, abstractButton);
            cache.put(object, bufferedImage);
        }
    }

    private void drawXpCheckMark(Graphics graphics, int n, int n2) {
        graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 7);
        graphics.drawLine(n + 4, n2 + 6, n + 4, n2 + 8);
        graphics.drawLine(n + 5, n2 + 7, n + 5, n2 + 9);
        graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 8);
        graphics.drawLine(n + 7, n2 + 5, n + 7, n2 + 7);
        graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 6);
        graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 5);
    }

    public int getIconWidth() {
        return checkSize;
    }

    public int getIconHeight() {
        return checkSize;
    }

    private static class CheckKey {
        private Color c;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        CheckKey(Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.c = color;
            this.pressed = bl;
            this.enabled = bl2;
            this.rollover = bl3;
            this.focused = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CheckKey)) {
                return false;
            }
            CheckKey checkKey = (CheckKey)object;
            return this.pressed == checkKey.pressed && this.enabled == checkKey.enabled && this.rollover == checkKey.rollover && this.focused == checkKey.focused && this.c.equals(checkKey.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    private static class DisabledCheckKey {
        int spread1 = Theme.buttonSpreadLightDisabled.getValue();
        int spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        Color c;
        Color back;

        DisabledCheckKey(Color color, Color color2) {
            this.c = color;
            this.back = color2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof DisabledCheckKey)) {
                return false;
            }
            DisabledCheckKey disabledCheckKey = (DisabledCheckKey)object;
            return this.c.equals(disabledCheckKey.c) && this.back.equals(disabledCheckKey.back) && this.spread1 == disabledCheckKey.spread1 && this.spread2 == disabledCheckKey.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    private static class EnabledCheckKey {
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        Color c;
        Color back;

        EnabledCheckKey(Color color, Color color2) {
            this.c = color;
            this.back = color2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof EnabledCheckKey)) {
                return false;
            }
            EnabledCheckKey enabledCheckKey = (EnabledCheckKey)object;
            return this.c.equals(enabledCheckKey.c) && this.back.equals(enabledCheckKey.back) && this.spread1 == enabledCheckKey.spread1 && this.spread2 == enabledCheckKey.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

