/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.borders.TinyButtonBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TinyComboBoxButton
extends JButton {
    private static final HashMap cache = new HashMap();
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    private static BufferedImage focusImg;

    public static void clearCache() {
        cache.clear();
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    TinyComboBoxButton() {
        super("");
        ImageIcon imageIcon;
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){

            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        };
        this.setModel(defaultButtonModel);
        this.setBackground(UIManager.getColor("ComboBox.background"));
        this.setForeground(UIManager.getColor("ComboBox.foreground"));
        if (focusImg == null && (imageIcon = TinyLookAndFeel.loadIcon("ComboBoxFocus.png")) != null) {
            focusImg = new BufferedImage(2, 2, 1);
            Graphics graphics = focusImg.getGraphics();
            imageIcon.paintIcon(this, graphics, 0, 0);
        }
    }

    public TinyComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        this();
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        int n;
        Serializable serializable;
        Color color = this.getParent().getParent().getBackground();
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        ButtonKey buttonKey = null;
        BufferedImage bufferedImage = null;
        Graphics graphics2 = graphics;
        boolean bl = false;
        if (!TinyLookAndFeel.controlPanelInstantiated) {
            buttonKey = new ButtonKey(color, this.getSize(), this.comboBox.isEnabled(), this.comboBox.isEditable(), this.model.isPressed(), this.model.isRollover());
            Object v = cache.get(buttonKey);
            if (v != null) {
                graphics.drawImage((Image)v, 0, 0, this);
                if (this.comboBox.isEditable()) {
                    return;
                }
                bl = true;
            } else {
                bufferedImage = new BufferedImage(n3, n2, 2);
                graphics2 = ((Image)bufferedImage).getGraphics();
            }
        }
        boolean bl2 = this.getComponentOrientation().isLeftToRight();
        if (!bl) {
            if (this.comboBox.isEnabled()) {
                if (this.comboBox.isEditable()) {
                    graphics2.setColor(Theme.textBgColor.getColor());
                } else {
                    graphics2.setColor(this.comboBox.getBackground());
                }
            } else {
                graphics2.setColor(Theme.textDisabledBgColor.getColor());
            }
            graphics2.fillRect(1, 1, n3 - 2, n2 - 2);
            graphics2.setColor(color);
            graphics2.drawRect(0, 0, n3 - 1, n2 - 1);
            serializable = null;
            serializable = !this.isEnabled() ? Theme.comboButtDisabledColor.getColor() : (this.model.isPressed() ? Theme.comboButtPressedColor.getColor() : (this.model.isRollover() ? Theme.comboButtRolloverColor.getColor() : Theme.comboButtColor.getColor()));
            graphics2.setColor((Color)serializable);
            Rectangle rectangle = new Rectangle(n3 - 18, 1, 18, n2 - 2);
            this.drawXpButton(graphics2, rectangle, (Color)serializable);
            Border border = this.getBorder();
            if (border != null && border instanceof TinyButtonBorder.CompoundBorderUIResource) {
                if (!this.isEnabled()) {
                    DrawRoutines.drawRoundedBorder(graphics2, Theme.comboBorderDisabledColor.getColor(), 0, 0, n3, n2);
                } else {
                    DrawRoutines.drawRoundedBorder(graphics2, Theme.comboBorderColor.getColor(), 0, 0, n3, n2);
                    if (!this.getModel().isPressed() && this.getModel().isRollover() && Theme.comboRollover.getValue()) {
                        DrawRoutines.drawRolloverBorder(graphics2, Theme.buttonRolloverColor.getColor(), 0, 0, n3, n2);
                    }
                }
            }
            if (buttonKey != null) {
                graphics2.dispose();
                graphics.drawImage(bufferedImage, 0, 0, this);
                cache.put(buttonKey, bufferedImage);
            }
        }
        serializable = new Insets(Theme.comboInsets.top, Theme.comboInsets.left, Theme.comboInsets.bottom, 0);
        int n4 = n = n3 - (serializable.left + serializable.right);
        int n5 = n2 - (serializable.top + serializable.bottom);
        if (n5 <= 0 || n <= 0) {
            return;
        }
        int n6 = serializable.left;
        int n7 = serializable.top;
        int n8 = n6 + (n - 1);
        int n9 = n7 + (n5 - 1);
        int n10 = 18;
        int n11 = bl2 ? n8 : n6;
        Component component = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!this.iconOnly && this.comboBox != null) {
            object = this.comboBox.getRenderer();
            boolean bl6 = this.getModel().isPressed();
            component = object.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl6, false);
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.select"));
                }
                component.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    component.setBackground(Theme.textDisabledBgColor.getColor());
                } else {
                    this.comboBox.setBackground(Theme.textDisabledBgColor.getColor());
                }
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else if (this.comboBox.hasFocus() && !this.comboBox.isPopupVisible()) {
                if (this.comboBox.isEditable()) {
                    component.setForeground(Theme.mainColor.getColor());
                } else {
                    component.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                }
                component.setBackground(UIManager.getColor("ComboBox.focusBackground"));
                if (component instanceof JComponent) {
                    bl3 = true;
                    JComponent jComponent = (JComponent)component;
                    bl4 = jComponent.isOpaque();
                    jComponent.setOpaque(true);
                    bl5 = true;
                }
            } else {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            }
            int n12 = n - (serializable.right + n10);
            boolean bl7 = component instanceof JPanel;
            if (bl2) {
                this.rendererPane.paintComponent(graphics, component, this, n6, n7, n12, n5, bl7);
            } else {
                this.rendererPane.paintComponent(graphics, component, this, n6 + n10, n7, n12, n5, bl7);
            }
            if (bl5 && Theme.comboFocus.getValue()) {
                graphics.setColor(Color.black);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = new Rectangle(n6, n7, 2, 2);
                TexturePaint texturePaint = new TexturePaint(focusImg, rectangle);
                graphics2D.setPaint(texturePaint);
                graphics2D.draw(new Rectangle(n6, n7, n12, n5));
            }
        }
        if (bl3) {
            object = (JComponent)component;
            ((JComponent)object).setOpaque(bl4);
        }
    }

    private void drawXpButton(Graphics graphics, Rectangle rectangle, Color color) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = Theme.comboSpreadLight.getValue();
        int n4 = Theme.comboSpreadDark.getValue();
        if (!this.isEnabled()) {
            n3 = Theme.comboSpreadLightDisabled.getValue();
            n4 = Theme.comboSpreadDarkDisabled.getValue();
        }
        int n5 = rectangle.height - 2;
        float f = 10.0f * (float)n3 / (float)(n5 - 3);
        float f2 = 10.0f * (float)n4 / (float)(n5 - 3);
        int n6 = n5 / 2;
        for (int i = 1; i < n5 - 1; ++i) {
            int n7;
            if (i < n6) {
                n7 = n6 - i;
                graphics.setColor(ColorRoutines.lighten(color, (int)((float)n7 * f)));
            } else if (i == n6) {
                graphics.setColor(color);
            } else {
                n7 = i - n6;
                graphics.setColor(ColorRoutines.darken(color, (int)((float)n7 * f2)));
            }
            graphics.drawLine(rectangle.x + 1, rectangle.y + i + 1, rectangle.x + rectangle.width - 3, rectangle.y + i + 1);
        }
        Color color2 = null;
        color2 = !this.isEnabled() ? Theme.comboButtBorderDisabledColor.getColor() : Theme.comboButtBorderColor.getColor();
        graphics.setColor(color2);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 1, n - 4, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 2, rectangle.x + 1, n2 - 3);
        graphics.drawLine(n - 3, rectangle.y + 2, n - 3, n2 - 3);
        graphics.drawLine(rectangle.x + 2, n2 - 2, n - 4, n2 - 2);
        color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 128);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + 1);
        graphics.drawLine(n - 3, rectangle.y + 1, n - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, n2 - 2, rectangle.x + 1, n2 - 2);
        graphics.drawLine(n - 3, n2 - 2, n - 3, n2 - 2);
        if (this.isEnabled()) {
            graphics.setColor(Theme.comboArrowColor.getColor());
        } else {
            graphics.setColor(Theme.comboArrowDisabledColor.getColor());
        }
        this.drawXpArrow(graphics, rectangle);
    }

    private void drawXpArrow(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x + (rectangle.width - 8) / 2 - 1;
        int n2 = rectangle.y + (rectangle.height - 6) / 2 + 1;
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n + 7, n2, n + 7, n2);
        graphics.drawLine(n, n2 + 1, n + 2, n2 + 1);
        graphics.drawLine(n + 6, n2 + 1, n + 8, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
        graphics.drawLine(n + 5, n2 + 2, n + 7, n2 + 2);
        graphics.drawLine(n + 2, n2 + 3, n + 6, n2 + 3);
        graphics.drawLine(n + 3, n2 + 4, n + 5, n2 + 4);
        graphics.drawLine(n + 4, n2 + 5, n + 4, n2 + 5);
    }

    private static class ButtonKey {
        private Color panelBackground;
        private Dimension size;
        private boolean enabled;
        private boolean editable;
        private boolean pressed;
        private boolean rollover;

        ButtonKey(Color color, Dimension dimension, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.panelBackground = color;
            this.size = dimension;
            this.enabled = bl;
            this.editable = bl2;
            this.pressed = bl3;
            this.rollover = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ButtonKey)) {
                return false;
            }
            ButtonKey buttonKey = (ButtonKey)object;
            return this.enabled == buttonKey.enabled && this.editable == buttonKey.editable && this.pressed == buttonKey.pressed && this.rollover == buttonKey.rollover && this.panelBackground.equals(buttonKey.panelBackground) && this.size.equals(buttonKey.size);
        }

        public int hashCode() {
            return this.panelBackground.hashCode() * this.size.hashCode() * (this.enabled ? 2 : 1) * (this.editable ? 8 : 4) * (this.pressed ? 32 : 16) * (this.rollover ? 128 : 64);
        }
    }
}

