/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;

public class TinySpinnerButtonUI
extends TinyButtonUI {
    private static final HashMap cache = new HashMap();
    private int orientation;
    protected static final Dimension xpSize = new Dimension(15, 8);

    public static void clearCache() {
        cache.clear();
    }

    public static Container getSpinnerParent(Component component) {
        boolean bl = false;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JSpinner)) continue;
            bl = true;
            if (!bl) continue;
            return container;
        }
        return null;
    }

    public static JSpinner getSpinner(Component component) {
        return (JSpinner)component.getParent();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinySpinnerButtonUI(int n) {
        this.orientation = n;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Theme.spinnerButtDisabledColor.getColor());
        } else if (abstractButton.getModel().isPressed()) {
            if (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed()) {
                graphics.setColor(Theme.spinnerButtPressedColor.getColor());
            } else {
                graphics.setColor(Theme.spinnerButtColor.getColor());
            }
        } else if (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed()) {
            graphics.setColor(Theme.spinnerButtRolloverColor.getColor());
        } else {
            graphics.setColor(Theme.spinnerButtColor.getColor());
        }
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(graphics, abstractButton);
        } else {
            this.drawXpButton(graphics, abstractButton);
        }
    }

    private void drawXpButton(Graphics graphics, AbstractButton abstractButton) {
        boolean bl = !abstractButton.getModel().isPressed() && abstractButton.getModel().isRollover() && Theme.spinnerRollover.getValue();
        Color color = TinySpinnerButtonUI.getSpinnerParent(abstractButton).getBackground();
        ButtonKey buttonKey = new ButtonKey(graphics.getColor(), color, abstractButton.getSize(), bl, this.orientation);
        Object v = cache.get(buttonKey);
        if (v != null) {
            graphics.drawImage((Image)v, 0, 0, abstractButton);
            return;
        }
        int n = abstractButton.getWidth() - 1;
        int n2 = abstractButton.getHeight() - 1;
        int n3 = abstractButton.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n + 1, n3, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        int n4 = Theme.spinnerSpreadLight.getValue();
        int n5 = Theme.spinnerSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            n4 = Theme.spinnerSpreadLightDisabled.getValue();
            n5 = Theme.spinnerSpreadDarkDisabled.getValue();
        }
        float f = 10.0f * (float)n4 / (float)(n3 - 2);
        float f2 = 10.0f * (float)n5 / (float)(n3 - 2);
        int n6 = n3 / 2;
        Color color2 = graphics.getColor();
        for (int i = 1; i < n3 - 1; ++i) {
            int n7;
            if (i < n6) {
                n7 = n6 - i;
                graphics2.setColor(ColorRoutines.lighten(color2, (int)((float)n7 * f)));
            } else if (i == n6) {
                graphics2.setColor(color2);
            } else {
                n7 = i - n6;
                graphics2.setColor(ColorRoutines.darken(color2, (int)((float)n7 * f2)));
            }
            graphics2.drawLine(1, i, n, i);
        }
        graphics2.setColor(color);
        graphics2.drawRect(0, 0, n, n2);
        graphics2.setColor(TinySpinnerButtonUI.getSpinner(abstractButton).getBackground());
        if (Boolean.TRUE.equals(abstractButton.getClientProperty("isNextButton"))) {
            graphics2.drawLine(0, n2, 0, n2);
        } else {
            graphics2.drawLine(0, 0, 0, 0);
        }
        if (!abstractButton.isEnabled()) {
            graphics2.setColor(Theme.spinnerBorderDisabledColor.getColor());
        } else {
            graphics2.setColor(Theme.spinnerBorderColor.getColor());
        }
        graphics2.drawLine(1, 0, n - 1, 0);
        graphics2.drawLine(1, n2, n - 1, n2);
        graphics2.drawLine(0, 1, 0, n2 - 1);
        graphics2.drawLine(n, 1, n, n2 - 1);
        if (bl) {
            DrawRoutines.drawRolloverBorder(graphics2, Theme.buttonRolloverColor.getColor(), 0, 0, n + 1, n3);
        }
        if (!abstractButton.isEnabled()) {
            graphics2.setColor(Theme.spinnerArrowDisabledColor.getColor());
        } else {
            graphics2.setColor(Theme.spinnerArrowColor.getColor());
        }
        this.drawXpArrow(graphics2, abstractButton);
        graphics2.dispose();
        graphics.drawImage(bufferedImage, 0, 0, abstractButton);
        cache.put(buttonKey, bufferedImage);
    }

    private void drawXpButtonNoCache(Graphics graphics, AbstractButton abstractButton) {
        boolean bl = !abstractButton.getModel().isPressed() && abstractButton.getModel().isRollover() && Theme.spinnerRollover.getValue();
        int n = abstractButton.getWidth() - 1;
        int n2 = abstractButton.getHeight() - 1;
        int n3 = n2 + 1;
        int n4 = Theme.spinnerSpreadLight.getValue();
        int n5 = Theme.spinnerSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            n4 = Theme.spinnerSpreadLightDisabled.getValue();
            n5 = Theme.spinnerSpreadDarkDisabled.getValue();
        }
        float f = 10.0f * (float)n4 / (float)(n3 - 2);
        float f2 = 10.0f * (float)n5 / (float)(n3 - 2);
        int n6 = n3 / 2;
        Color color = graphics.getColor();
        for (int i = 1; i < n3 - 1; ++i) {
            int n7;
            if (i < n6) {
                n7 = n6 - i;
                graphics.setColor(ColorRoutines.lighten(color, (int)((float)n7 * f)));
            } else if (i == n6) {
                graphics.setColor(color);
            } else {
                n7 = i - n6;
                graphics.setColor(ColorRoutines.darken(color, (int)((float)n7 * f2)));
            }
            graphics.drawLine(1, i, n, i);
        }
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Theme.spinnerArrowDisabledColor.getColor());
        } else {
            graphics.setColor(Theme.spinnerArrowColor.getColor());
        }
        this.drawXpArrow(graphics, abstractButton);
    }

    private void drawXpArrow(Graphics graphics, AbstractButton abstractButton) {
        int n = (abstractButton.getSize().height - 6) / 2;
        switch (this.orientation) {
            case 1: {
                graphics.drawLine(7, --n + 2, 7, n + 2);
                graphics.drawLine(6, n + 3, 8, n + 3);
                graphics.drawLine(5, n + 4, 9, n + 4);
                graphics.drawLine(4, n + 5, 6, n + 5);
                graphics.drawLine(8, n + 5, 10, n + 5);
                break;
            }
            case 5: {
                graphics.drawLine(4, n + 2, 6, n + 2);
                graphics.drawLine(8, n + 2, 10, n + 2);
                graphics.drawLine(5, n + 3, 9, n + 3);
                graphics.drawLine(6, n + 4, 8, n + 4);
                graphics.drawLine(7, n + 5, 7, n + 5);
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return xpSize;
    }

    private static class ButtonKey {
        private Color background;
        private Color parentBackground;
        private Dimension size;
        private boolean rollover;
        private int orientation;

        ButtonKey(Color color, Color color2, Dimension dimension, boolean bl, int n) {
            this.background = color;
            this.parentBackground = color2;
            this.size = dimension;
            this.rollover = bl;
            this.orientation = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ButtonKey)) {
                return false;
            }
            ButtonKey buttonKey = (ButtonKey)object;
            return this.orientation == buttonKey.orientation && this.rollover == buttonKey.rollover && this.background.equals(buttonKey.background) && this.parentBackground.equals(buttonKey.parentBackground) && this.size.equals(buttonKey.size);
        }

        public int hashCode() {
            return this.background.hashCode() * this.parentBackground.hashCode() * this.size.hashCode() * this.orientation * (this.rollover ? 2 : 1);
        }
    }
}

