/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinySpinnerButtonUI;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;

public class TinyButtonBorder
extends AbstractBorder
implements UIResource {
    protected final Insets borderInsets = new Insets(2, 2, 2, 2);

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!TinyLookAndFeel.controlPanelInstantiated) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        boolean bl = Boolean.TRUE.equals(abstractButton.getClientProperty("isComboBoxButton"));
        if (bl) {
            if (!abstractButton.isEnabled()) {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderDisabledColor.getColor(), n, n2, n3, n4);
            } else {
                DrawRoutines.drawRoundedBorder(graphics, Theme.comboBorderColor.getColor(), n, n2, n3, n4);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && Theme.comboRollover.getValue()) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), n, n2, n3, n4);
                }
            }
        } else {
            boolean bl2;
            boolean bl3 = Boolean.TRUE.equals(abstractButton.getClientProperty("isSpinnerButton"));
            boolean bl4 = bl2 = bl3 && Theme.spinnerRollover.getValue() || !bl3 && Theme.buttonRolloverBorder.getValue();
            if (bl3) {
                graphics.setColor(TinySpinnerButtonUI.getSpinnerParent(abstractButton).getBackground());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(TinySpinnerButtonUI.getSpinner(abstractButton).getBackground());
                if (Boolean.TRUE.equals(abstractButton.getClientProperty("isNextButton"))) {
                    graphics.drawLine(0, n4 - 1, 0, n4 - 1);
                } else {
                    graphics.drawLine(0, 0, 0, 0);
                }
                if (!abstractButton.isEnabled()) {
                    graphics.setColor(Theme.spinnerBorderDisabledColor.getColor());
                } else {
                    graphics.setColor(Theme.spinnerBorderColor.getColor());
                }
                graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
                graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
                if (abstractButton.getModel().isPressed()) {
                    return;
                }
                if (abstractButton.getModel().isRollover() && bl2) {
                    DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), n, n2, n3, n4);
                }
            } else {
                boolean bl5;
                boolean bl6 = bl5 = component instanceof JButton && ((JButton)component).isDefaultButton();
                if (!abstractButton.isEnabled()) {
                    DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderDisabledColor.getColor(), n, n2, n3, n4);
                } else {
                    DrawRoutines.drawRoundedBorder(graphics, Theme.buttonBorderColor.getColor(), n, n2, n3, n4);
                    if (abstractButton.getModel().isPressed()) {
                        return;
                    }
                    if (abstractButton.getModel().isRollover() && bl2) {
                        DrawRoutines.drawRolloverBorder(graphics, Theme.buttonRolloverColor.getColor(), n, n2, n3, n4);
                    } else if (bl5 || Theme.buttonFocusBorder.getValue() && abstractButton.isFocusOwner() && abstractButton.isFocusPainted()) {
                        DrawRoutines.drawRolloverBorder(graphics, Theme.buttonDefaultColor.getColor(), n, n2, n3, n4);
                    }
                }
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.borderInsets;
    }

    public static class CompoundBorderUIResource
    extends CompoundBorder
    implements UIResource {
        public CompoundBorderUIResource(Border border, Border border2) {
            super(border, border2);
        }
    }
}

