/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

public enum ConsoleColor {
    RESET("\u001b[0m"),
    BLACK("\u001b[30m"),
    RED("\u001b[31m"),
    GREEN("\u001b[32m"),
    YELLOW("\u001b[33m"),
    BLUE("\u001b[34m"),
    MAGENTA("\u001b[35m"),
    CYAN("\u001b[36m"),
    WHITE("\u001b[37m");

    private final String escapeSequence;

    private ConsoleColor(String escapeSequence) {
        this.escapeSequence = escapeSequence;
    }

    public static CharSequence build(ConsoleColor color, Object ... data) {
        return ConsoleColor.build(color, true, data);
    }

    public static CharSequence build(ConsoleColor color, boolean reset, Object ... data) {
        StringBuilder sb = new StringBuilder(color.getEscapeSequence());
        for (Object d : data) {
            sb.append(d);
        }
        if (reset) {
            sb.append(RESET.getEscapeSequence());
        }
        return sb.toString();
    }

    public static CharSequence conditional(boolean condition, ConsoleColor positive, ConsoleColor negative, Object ... data) {
        if (condition) {
            return positive.build(data);
        }
        return negative.build(data);
    }

    public String toString() {
        return this.getEscapeSequence();
    }

    public String toString(Object ... data) {
        return this.build(data).toString();
    }

    public String getEscapeSequence() {
        return this.escapeSequence;
    }

    public CharSequence build(Object ... data) {
        return ConsoleColor.build(this, data);
    }

    public CharSequence build(boolean reset, Object ... data) {
        return ConsoleColor.build(this, reset, data);
    }
}

