/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;

public class TinyTextFieldUI
extends MetalTextFieldUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyTextFieldUI();
    }

    protected void paintBackground(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEnabled()) {
            if (jTextComponent.isEditable()) {
                graphics.setColor(jTextComponent.getBackground());
            } else if (jTextComponent.getBackground() instanceof ColorUIResource) {
                graphics.setColor(Theme.textNonEditableBgColor.getColor());
            } else {
                graphics.setColor(jTextComponent.getBackground());
            }
            graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        } else {
            if (jTextComponent.getBackground() instanceof ColorUIResource) {
                graphics.setColor(Theme.textDisabledBgColor.getColor());
            } else {
                graphics.setColor(jTextComponent.getBackground());
            }
            graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
            if (jTextComponent.getBorder() == null) {
                return;
            }
            graphics.setColor(Theme.backColor.getColor());
            graphics.drawRect(1, 1, jTextComponent.getWidth() - 3, jTextComponent.getHeight() - 3);
            graphics.drawRect(2, 2, jTextComponent.getWidth() - 5, jTextComponent.getHeight() - 5);
        }
    }
}

