/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRadioButtonMenuItemUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class TextureRadioButtonMenuItemUI
extends BaseRadioButtonMenuItemUI {
    public static ComponentUI createUI(JComponent c) {
        return new TextureRadioButtonMenuItemUI();
    }

    protected void paintBackground(Graphics g, JComponent c, int x, int y, int w, int h) {
        JMenuItem mi = (JMenuItem)c;
        ButtonModel model = mi.getModel();
        if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
            TextureUtils.fillComponent(g, c, 4);
        } else if (!(mi.getBackground() instanceof ColorUIResource)) {
            super.paintBackground(g, c, x, y, w, h);
        } else {
            TextureUtils.fillComponent(g, c, 7);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintText(g, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(menuItem, g, menuItem.getFont());
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!menuItem.isArmed()) {
            g.setColor(Color.black);
            JTattooUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
        }
        if (!model.isEnabled()) {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0));
        } else if (menuItem.isArmed()) {
            g.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            Color foreColor = menuItem.getForeground();
            if (foreColor instanceof UIResource) {
                foreColor = AbstractLookAndFeel.getMenuForegroundColor();
            }
            g.setColor(foreColor);
        }
        JTattooUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

